﻿using System;

namespace Jeneva.Validation
{
    /// <summary>
    /// Defines arithmetic operations.
    /// All methods return 'false' if one of the parameters is NULL, otherwise arithmetic result is returned
    /// </summary>
    public interface IMath
    {
        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(long? a, long? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(long? a, long? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(long? a, long? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(long? a, long? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(long? a, long? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(long? a, long? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(ulong? a, ulong? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(ulong? a, ulong? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(ulong? a, ulong? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(ulong? a, ulong? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(ulong? a, ulong? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(ulong? a, ulong? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(int? a, int? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(int? a, int? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(int? a, int? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(int? a, int? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(int? a, int? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(int? a, int? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(uint? a, uint? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(uint? a, uint? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(uint? a, uint? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(uint? a, uint? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(uint? a, uint? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(uint? a, uint? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(short? a, short? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(short? a, short? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(short? a, short? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(short? a, short? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(short? a, short? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(short? a, short? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(ushort? a, ushort? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(ushort? a, ushort? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(ushort? a, ushort? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(ushort? a, ushort? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(ushort? a, ushort? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(ushort? a, ushort? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(byte? a, byte? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(byte? a, byte? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(byte? a, byte? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(byte? a, byte? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(byte? a, byte? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(byte? a, byte? b);







        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLess(sbyte? a, sbyte? b);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreater(sbyte? a, sbyte? b);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(sbyte? a, sbyte? b);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(sbyte? a, sbyte? b);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsEqual(sbyte? a, sbyte? b);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(sbyte? a, sbyte? b);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsLess(double? a, double? b, int decimals);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsGreater(double? a, double? b, int decimals);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(double? a, double? b, int decimals);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(double? a, double? b, int decimals);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsEqual(double? a, double? b, int decimals);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(double? a, double? b, int decimals);







        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsLess(decimal? a, decimal? b, int decimals);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsGreater(decimal? a, decimal? b, int decimals);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(decimal? a, decimal? b, int decimals);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(decimal? a, decimal? b, int decimals);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsEqual(decimal? a, decimal? b, int decimals);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(decimal? a, decimal? b, int decimals);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsLess(float? a, float? b, int decimals);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsGreater(float? a, float? b, int decimals);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(float? a, float? b, int decimals);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(float? a, float? b, int decimals);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsEqual(float? a, float? b, int decimals);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="decimals">number of decimals to round</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(float? a, float? b, int decimals);






        /// <summary>
        /// Checks if a is less than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="noTime">true if time is discarded</param>
        /// <returns>true if yes</returns>
        bool IsLess(DateTime? a, DateTime? b, bool noTime);

        /// <summary>
        /// Checks if a is greater than b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="noTime">true if time is discarded</param>
        /// <returns>true if yes</returns>
        bool IsGreater(DateTime? a, DateTime? b, bool noTime);

        /// <summary>
        /// Checks if a is less than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="noTime">true if time is discarded</param>
        /// <returns>true if yes</returns>
        bool IsLessOrEqual(DateTime? a, DateTime? b, bool noTime);

        /// <summary>
        /// Checks if a is greater than or equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="noTime">true if time is discarded</param>
        /// <returns>true if yes</returns>
        bool IsGreaterOrEqual(DateTime? a, DateTime? b, bool noTime);

        /// <summary>
        /// Checks if a is equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="noTime">true if time is discarded</param>
        /// <returns>true if yes</returns>
        bool IsEqual(DateTime? a, DateTime? b, bool noTime);

        /// <summary>
        /// Checks if a is not equal to b (returns false if at least one of the parameters is NULL)
        /// </summary>
        /// <param name="a">a</param>
        /// <param name="b">b</param>
        /// <param name="noTime">true if time is discarded</param>
        /// <returns>true if yes</returns>
        bool IsNotEqual(DateTime? a, DateTime? b, bool noTime);
    }
}